/*
 * Decompiled with CFR 0.152.
 */
package oracle.install.commons.bean.xml;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.stream.StreamResult;
import oracle.install.commons.bean.BasicBeanStoreSource;
import oracle.install.commons.bean.BeanStore;
import oracle.install.commons.bean.BeanStoreErrorCode;
import oracle.install.commons.bean.BeanStoreException;
import oracle.install.commons.bean.BeanStoreSource;
import oracle.install.commons.bean.xml.XmlBeanStoreFormat;
import oracle.install.commons.bean.xml.XmlBeanStoreFormatRegistry;
import oracle.install.commons.bean.xml.XmlBeanStoreReader;
import oracle.install.commons.bean.xml.XmlBeanStoreWriter;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public class XmlBeanStore
extends BeanStore<XmlBeanStoreWriter, XmlBeanStoreReader> {
    private static Logger logger = Logger.getLogger(XmlBeanStore.class.getName());
    private Document document;
    private File file;
    private URL sourceURL;
    private XmlBeanStoreFormat format;

    public XmlBeanStore() {
        this((String)null);
    }

    public XmlBeanStore(String beanStoreName) {
        this(beanStoreName, BeanStore.AccessMode.READ_ONLY, null, null);
    }

    public XmlBeanStore(String beanStoreName, BeanStore.AccessMode accessMode, URL url, XmlBeanStoreFormat format) {
        super(beanStoreName, accessMode);
        this.sourceURL = url;
    }

    public XmlBeanStore(BeanStoreSource beanStoreSource) throws BeanStoreException {
        beanStoreSource.link(this);
        if (beanStoreSource instanceof BasicBeanStoreSource) {
            this.setSourceURL(((BasicBeanStoreSource)beanStoreSource).getSourceURL());
            this.setFormat(null);
        }
    }

    public XmlBeanStoreFormat getFormat() {
        return this.format;
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public URL getSourceURL() {
        return this.sourceURL;
    }

    public void setSourceURL(URL sourceURL) {
        this.sourceURL = sourceURL;
    }

    public void setFormat(XmlBeanStoreFormat format) {
        this.format = format == null ? XmlBeanStoreFormatRegistry.getInstance().getDefaultFormat() : format;
    }

    @Override
    public void load() throws BeanStoreException {
        if (this.sourceURL != null) {
            if (this.format == null) {
                throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_XML_BEANSTORE_FORMAT, new Object[0]);
            }
            try {
                logger.log(Level.INFO, "Loading beanstore from {0}", this.sourceURL);
                this.document = this.format.ext2raw(new InputSource(this.sourceURL.toExternalForm()));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load beanstore from {0}. Reason: {1}", new Object[]{this.sourceURL, e.getMessage()});
                throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_LOAD_BEANSTORE, new Object[0]);
            }
        }
        logger.log(Level.INFO, "Loading a new beanstore in memory");
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            this.document = docBuilder.newDocument();
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to load a new beanstore in memory. Reason: {0}", e.getMessage());
            throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_LOAD_BEANSTORE, new Object[0]);
        }
    }

    @Override
    public void load(InputStream in) throws BeanStoreException {
        if (in != null) {
            if (this.format == null) {
                throw new BeanStoreException(BeanStoreErrorCode.UNSPECIFIED_XML_BEANSTORE_FORMAT, new Object[0]);
            }
            try {
                logger.log(Level.INFO, "Loading beanstore from a given input stream");
                this.document = this.format.ext2raw(new InputSource(in));
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Failed to load beanstore from the given input stream. Reason: {1}", e.getMessage());
                throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_LOAD_BEANSTORE, new Object[0]);
            }
        }
    }

    public Document getDocument() {
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    @Override
    public void save() throws BeanStoreException {
        if (this.document != null && this.file != null) {
            try {
                logger.log(Level.INFO, "Saving the bean store to file {0}", this.file);
                FileOutputStream out = new FileOutputStream(this.file);
                this.save(out);
                out.close();
                logger.log(Level.INFO, "Successfully saved the bean store to file {0}", this.file);
            }
            catch (BeanStoreException e) {
                throw e;
            }
            catch (Exception e) {
                throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_SAVE_BEANSTORE, new Object[0]);
            }
        }
    }

    @Override
    public void save(OutputStream out) throws BeanStoreException {
        if (this.document != null) {
            try {
                this.format.raw2ext(this.document, new StreamResult(out));
            }
            catch (Exception e) {
                throw new BeanStoreException((Throwable)e, BeanStoreErrorCode.UNABLE_TO_SAVE_BEANSTORE, new Object[0]);
            }
        }
    }

    @Override
    public XmlBeanStoreReader newBeanStoreReader() throws BeanStoreException {
        XmlBeanStoreReader reader = new XmlBeanStoreReader();
        reader.open(this);
        return reader;
    }

    @Override
    public XmlBeanStoreWriter newBeanStoreWriter() throws BeanStoreException {
        XmlBeanStoreWriter writer = new XmlBeanStoreWriter();
        writer.open(this);
        return writer;
    }
}

